using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	[UsedImplicitly]
	internal abstract class GetEntityListAbs<T> : AbsWebAPI where T : EntityAlive {
		private static readonly byte[] jsonKeyId = JsonWriter.GetEncodedPropertyNameWithBeginObject ("id");
		private static readonly byte[] jsonKeyName = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("name");
		private static readonly byte[] jsonKeyPosition = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("position");

		private readonly List<T> entities = new List<T> ();
		private readonly Action<List<T>> getterMethod;
		

		protected GetEntityListAbs (Action<List<T>> _getterMethod) {
			getterMethod = _getterMethod;
		}

		public override void HandleRequest (RequestContext _context) {
			JsonWriter writer = new JsonWriter ();
			writer.WriteBeginArray ();

			getterMethod (entities);
			for (int i = 0; i < entities.Count; i++) {
				T entity = entities [i];
				Vector3i position = new Vector3i (entity.GetPosition ());

				if (i > 0) {
					writer.WriteValueSeparator ();
				}
				
				writer.WriteRaw (jsonKeyId);
				writer.WriteInt32 (entity.entityId);
				
				writer.WriteRaw (jsonKeyName);
				if (!string.IsNullOrEmpty (entity.EntityName)) {
					writer.WriteString (entity.EntityName);
				} else {
					writer.WriteString ($"entity class #{entity.entityClass}");
				}
				
				writer.WriteRaw (jsonKeyPosition);
				JsonCommons.WriteVector3I (ref writer, position);
				
				writer.WriteEndObject ();
			}
			
			writer.WriteEndArray ();
			WebUtils.WriteJsonData (_context.Response, ref writer);
		}
	}
}