using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	[UsedImplicitly]
	public class GetAllowedCommands : AbsWebAPI {
		private static readonly byte[] jsonKeyCommands = JsonWriter.GetEncodedPropertyNameWithBeginObject ("commands");

		private static readonly byte[] jsonKeyCommand = JsonWriter.GetEncodedPropertyNameWithBeginObject ("command");
		private static readonly byte[] jsonKeyDescription = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("description");
		private static readonly byte[] jsonKeyHelp = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("help");

		public override void HandleRequest (RequestContext _context) {
			JsonWriter writer = new JsonWriter ();
			
			writer.WriteRaw (jsonKeyCommands);
			writer.WriteBeginArray ();

			bool first = true;

			foreach (IConsoleCommand cc in SdtdConsole.Instance.GetCommands ()) {
				int commandPermissionLevel = GameManager.Instance.adminTools.Commands.GetCommandPermissionLevel (cc.GetCommands ());
				if (_context.PermissionLevel > commandPermissionLevel) {
					continue;
				}

				string cmd = string.Empty;
				foreach (string s in cc.GetCommands ()) {
					if (s.Length > cmd.Length) {
						cmd = s;
					}
				}

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;
				
				writer.WriteRaw (jsonKeyCommand);
				writer.WriteString (cmd);
				
				writer.WriteRaw (jsonKeyDescription);
				writer.WriteString (cc.GetDescription ());
				
				writer.WriteRaw (jsonKeyHelp);
				if (cc.GetHelp () == null) {
					writer.WriteString ("");
				} else {
					writer.WriteString (cc.GetHelp ());
				}

				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();
			writer.WriteEndObject ();
			
			WebUtils.WriteJsonData (_context.Response, ref writer);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}