using System;
using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs.ServerState {
	[UsedImplicitly]
	public class GamePrefs : KeyValueListAbs {
		public GamePrefs () : base ("GamePrefs") {
		}

		protected override void iterateList (ref JsonWriter _writer, ref bool _first) {
			foreach (EnumGamePrefs stat in EnumUtils.Values<EnumGamePrefs> ()) {
				string name = stat.ToStringCached ();

				if (name.Contains ("Password", StringComparison.Ordinal)) {
					continue;
				}

				global::GamePrefs.EnumType? type = global::GamePrefs.GetPrefType (stat);
				object defaultValue = global::GamePrefs.GetDefault (stat);

				switch (type) {
					case global::GamePrefs.EnumType.Int:
						int? defaultInt = defaultValue as int?;
						addItem (ref _writer, ref _first, name, global::GamePrefs.GetInt (stat), defaultInt);
						break;
					case global::GamePrefs.EnumType.Float:
						float? defaultFloat = defaultValue as float?;
						addItem (ref _writer, ref _first, name, global::GamePrefs.GetFloat (stat), defaultFloat);
						break;
					case global::GamePrefs.EnumType.String:
						string defaultString = defaultValue as string;
						addItem (ref _writer, ref _first, name, global::GamePrefs.GetString (stat), defaultString);
						break;
					case global::GamePrefs.EnumType.Bool:
						bool? defaultBool = defaultValue as bool?;
						addItem (ref _writer, ref _first, name, global::GamePrefs.GetBool (stat), defaultBool);
						break;
				}
			}
		}

	}
}