using System.Collections.Generic;
using JetBrains.Annotations;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs.ServerState {
	[UsedImplicitly]
	public class ServerInfo : KeyValueListAbs {
		public ServerInfo () : base ("ServerInfo") {
		}

		protected override void iterateList (ref JsonWriter _writer, ref bool _first) {
			GameServerInfo gsi = ConnectionManager.Instance.LocalServerInfo;

			IList<GameInfoString> list = EnumUtils.Values<GameInfoString> ();
			for (int i = 0; i < list.Count; i++) {
				GameInfoString stringGamePref = list [i];
				addItem (ref _writer, ref _first, stringGamePref.ToStringCached (), gsi.GetValue (stringGamePref));
			}

			IList<GameInfoInt> ints = EnumUtils.Values<GameInfoInt> ();
			for (int i = 0; i < ints.Count; i++) {
				GameInfoInt intGamePref = ints [i];
				addItem (ref _writer, ref _first, intGamePref.ToStringCached (), gsi.GetValue (intGamePref));
			}

			IList<GameInfoBool> prefs = EnumUtils.Values<GameInfoBool> ();
			for (int i = 0; i < prefs.Count; i++) {
				GameInfoBool boolGamePref = prefs [i];
				addItem (ref _writer, ref _first, boolGamePref.ToStringCached (), gsi.GetValue (boolGamePref));
			}
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}