using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs.ServerState {
	[UsedImplicitly]
	public class GameStats : KeyValueListAbs {
		public GameStats () : base ("GameStats") {
		}

		protected override void iterateList (ref JsonWriter _writer, ref bool _first) {
			foreach (EnumGameStats stat in EnumUtils.Values<EnumGameStats> ()) {
				string name = stat.ToStringCached ();
				global::GameStats.EnumType? type = global::GameStats.GetStatType (stat);

				switch (type) {
					case global::GameStats.EnumType.Int:
						addItem (ref _writer, ref _first, name, global::GameStats.GetInt (stat));
						break;
					case global::GameStats.EnumType.Float:
						addItem (ref _writer, ref _first, name, global::GameStats.GetFloat (stat));
						break;
					case global::GameStats.EnumType.String:
						addItem (ref _writer, ref _first, name, global::GameStats.GetString (stat));
						break;
					case global::GameStats.EnumType.Bool:
						addItem (ref _writer, ref _first, name, global::GameStats.GetBool (stat));
						break;
				}
			}
		}
	}
}