using System;
using System.IO;
using System.Reflection;

namespace Webserver {
	public static class ResourceHelpers {
		public static Stream OpenManifestResource (Assembly _assembly, string _name, bool _ignoreCase = false) {
			string[] resourceNames = _assembly.GetManifestResourceNames ();
			foreach (string resourceName in resourceNames) {
				if (!resourceName.EndsWith (_name, _ignoreCase ? StringComparison.OrdinalIgnoreCase : StringComparison.Ordinal)) {
					continue;
				}
				
				return _assembly.GetManifestResourceStream (resourceName);
			}

			return null;
		}

		public static string GetManifestResourceText (Assembly _assembly, string _name, bool _ignoreCase = false) {
			using Stream manifestResourceStream = OpenManifestResource (_assembly, _name, _ignoreCase);
			if (manifestResourceStream == null) {
				return null;
			}
				
			using TextReader reader = new StreamReader (manifestResourceStream);
			return reader.ReadToEnd ();
		}
		
	}
}