using System.Net;
using JetBrains.Annotations;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs {
	[UsedImplicitly]
	public class OpenAPI : AbsRestApi {
		public OpenAPI (Web _parentWeb) : base (_parentWeb) {
		}

		protected override void HandleRestGet (RequestContext _context) {
			string path = _context.RequestPath;
			
			if (!ParentWeb.OpenApiHelpers.TryGetOpenApiSpec (path, out string specText)) {
				WebUtils.WriteText (_context.Response, $"Spec for {path} not found", HttpStatusCode.NotFound);
				return;
			}

			WebUtils.WriteText (_context.Response, specText, _mimeType: "text/x-yaml");
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}