using System.IO;
using Webserver.FileCache;
using Webserver.UrlHandlers;

namespace Webserver {
	public class WebMod {
		private const string modsBaseUrl = "/webmods/";
		private const string reactBundleName = "bundle.js";
		private const string stylingFileName = "styling.css";
		
		public readonly Mod ParentMod;
		/// <summary>
		/// Absolute web path to the mod web root, e.g. "/webmods/myMod/"
		/// </summary>
		public readonly string ModUrl;
		/// <summary>
		/// Absolute web path to the React bundle if the mod has one, e.g. "/webmods/myMod/bundle.js"
		/// </summary>
		public readonly string ReactBundle;
		/// <summary>
		/// Absolute web path to a CSS if the mod has one, e.g. "/webmods/myMod/styling.css"
		/// </summary>
		public readonly string CssPath;
		public readonly bool IsWebMod;

		public WebMod (Web _parentWeb, Mod _parentMod, bool _useStaticCache) {
			ParentMod = _parentMod;

			string folder = $"{_parentMod.Path}/WebMod";
			IsWebMod = Directory.Exists (folder);

			if (!IsWebMod) {
				return;
			}

			ModUrl = $"{modsBaseUrl}{_parentMod.Name}/";

			ReactBundle = $"{folder}/{reactBundleName}";
			ReactBundle = File.Exists (ReactBundle) ? $"{ModUrl}{reactBundleName}" : null;

			CssPath = $"{folder}/{stylingFileName}";
			CssPath = File.Exists (CssPath) ? $"{ModUrl}{stylingFileName}" : null;

			_parentWeb.RegisterPathHandler (ModUrl, new StaticHandler (
				folder,
				_useStaticCache ? new SimpleCache () : new DirectAccess (),
				false)
			);
		}
	}
}