using System;
using System.IO;
using JetBrains.Annotations;
using Webserver.FileCache;
using Webserver.UrlHandlers;

namespace AllocsFixes.Web {
	[UsedImplicitly]
	public class API : IModApi {
		private static Mod modInstance;
		
		public void InitMod (Mod _modInstance) {
			modInstance = _modInstance;

			Webserver.Web.ServerInitialized += OnWebServerInitialized;
		}

		private static void OnWebServerInitialized (Webserver.Web _web) {
			try {
				const string legacyModUrl = "/legacymap";
				const string legacyFilesFoldername = "webserver_legacy";
				string legacyFilePath = $"{modInstance.Path}/{legacyFilesFoldername}";

				if (!Directory.Exists (legacyFilePath)) {
					Log.Out ($"Legacy webmod feature not started (folder \"{legacyFilesFoldername}\" not found in Allocs_WebAndMapRendering mod folder)");
					return;
				}

				// TODO: Read from config
				bool useStaticCache = false;

				_web.RegisterPathHandler ($"{legacyModUrl}", new SimpleRedirectHandler ($"{legacyModUrl}/index.html"));
				_web.RegisterPathHandler ($"{legacyModUrl}/", new StaticHandler (legacyFilePath, useStaticCache ? new SimpleCache () : new DirectAccess (), false));

				int webPort = GamePrefs.GetInt (EnumUtils.Parse<EnumGamePrefs> (nameof(EnumGamePrefs.WebDashboardPort)));
				Log.Out ($"Started legacy webmod feature on port {webPort}, local address {legacyModUrl}");
			} catch (Exception e) {
				Log.Out ($"Error in Web.ctor: {e}");
			}
		}
	}
}