using JetBrains.Annotations;
using Utf8Json;
using Webserver.UrlHandlers;
using Webserver.WebAPI.APIs;

namespace Webserver.SSE {
	[UsedImplicitly]
	public class EventLog : AbsEvent {
		public EventLog (SseHandler _parent) : base (_parent, _name: "log") {
			LogBuffer.EntryAdded += LogCallback;
		}

		private void LogCallback (LogBuffer.LogEntry _logEntry) {
			JsonWriter writer = new JsonWriter ();
			LogApi.WriteLogMessageObject (ref writer, _logEntry);
			
			SendData ("logLine", writer.ToString ());
		}
	}
}