using JetBrains.Annotations;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs.GameData {
	[UsedImplicitly]
	public class Mods : AbsRestApi {
		private readonly byte[] loadedWebMods;

		public Mods (Web _parent) {
			JsonWriter writer = new JsonWriter ();
			writer.WriteBeginArray ();

			for (int i = 0; i < _parent.WebMods.Count; i++) {
				WebMod webMod = _parent.WebMods [i];

				if (i > 0) {
					writer.WriteValueSeparator ();
				}
				
				writeModJson (ref writer, webMod);
			}

			writer.WriteEndArray ();

			loadedWebMods = writer.ToUtf8ByteArray ();
		}

		private static void writeModJson (ref JsonWriter _writer, WebMod _webMod) {
			_writer.WriteBeginObject ();

			_writer.WritePropertyName ("name");
			_writer.WriteString (_webMod.ParentMod.Name);
			
			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("displayName");
			_writer.WriteString (_webMod.ParentMod.DisplayName);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("description");
			_writer.WriteString (_webMod.ParentMod.Description);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("author");
			_writer.WriteString (_webMod.ParentMod.Author);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("version");
			_writer.WriteString (_webMod.ParentMod.VersionString);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("website");
			_writer.WriteString (_webMod.ParentMod.Website);
			
			writeWebModJson (ref _writer, _webMod);

			_writer.WriteEndObject ();
		}

		private static void writeWebModJson (ref JsonWriter _writer, WebMod _webMod) {
			if (_webMod.ModUrl != null) {
				_writer.WriteValueSeparator ();

				_writer.WritePropertyName ("web");
				_writer.WriteBeginObject ();
				
				_writer.WritePropertyName ("baseUrl");
				_writer.WriteString (_webMod.ModUrl);

				string webModReactBundle = _webMod.ReactBundle;
				if (webModReactBundle != null) {
					_writer.WriteValueSeparator ();
					_writer.WritePropertyName ("bundle");
					_writer.WriteString (webModReactBundle);
				}

				string webModCssFile = _webMod.CssPath;
				if (webModCssFile != null) {
					_writer.WriteValueSeparator ();
					_writer.WritePropertyName ("css");
					_writer.WriteString (webModCssFile);
				}

				_writer.WriteEndObject ();
			}
		}

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteRaw (loadedWebMods);
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}
