﻿using JetBrains.Annotations;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs.GameData {
	[UsedImplicitly]
	internal class EntityClass : AbsRestApi {
		private static readonly byte[] jsonKeyName = JsonWriter.GetEncodedPropertyNameWithBeginObject ("name");
		private static readonly byte[] jsonKeyId = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("id");
		private static readonly byte[] jsonKeyCommandIndex = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("commandId");
		private static readonly byte[] jsonKeyManualSpawnType = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("manualSpawnType");

		private readonly byte[] allClassesSerialized;

		public EntityClass (Web _parent) {
			JsonWriter writer = new JsonWriter ();
			
			writer.WriteBeginArray ();

			int written = 0;
			int iCommandIndex = 0;
			foreach ((int id, global::EntityClass entityClass) in global::EntityClass.list.Dict) {
				if (written > 0) {
					writer.WriteValueSeparator ();
				}

				written++;

				string name = entityClass.entityClassName;
				global::EntityClass.UserSpawnType spawnType = entityClass.userSpawnType;
				
				writer.WriteRaw (jsonKeyName);
				writer.WriteString (name);

				writer.WriteRaw (jsonKeyId);
				writer.WriteInt32 (id);

				if (entityClass.userSpawnType != global::EntityClass.UserSpawnType.None) {
					iCommandIndex++;
			
					writer.WriteRaw (jsonKeyCommandIndex);
					writer.WriteInt32 (iCommandIndex);
				}

				writer.WriteRaw (jsonKeyManualSpawnType);
				writer.WriteString (spawnType.ToStringCached ());
				
				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();

			allClassesSerialized = writer.ToUtf8ByteArray ();
		}

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteRaw (allClassesSerialized);
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}