namespace Webserver.WebAPI
{
    public enum EApiErrorCode {
        NO_PERMISSION,

        // User management:
        NO_USER,
        INVALID_USER,
			
        // Blacklist:
        NO_OR_INVALID_BANNED_UNTIL,
			
        // Command / CommandPermissions:
        NO_COMMAND,
        UNKNOWN_COMMAND,
			
        // Permissions related:
        NO_OR_INVALID_PERMISSION_LEVEL,
        NO_OR_INVALID_PERMISSION_LEVEL_MODS,
        NO_OR_INVALID_PERMISSION_LEVEL_NORMAL,
			
        // User registration:
        INVALID_OR_EXPIRED_TOKEN,
        MISSING_TOKEN,
        MISSING_USERNAME,
        MISSING_PASSWORD,
        INVALID_USERNAME,
        INVALID_PASSWORD,
        DUPLICATE_USERNAME,
			
        // WebApiTokens:
        NO_NAME,
        NO_OR_INVALID_SECRET,
			
        // WebModules:
        NO_MODULE,
        INVALID_MODULE,
        INVALID_PERMISSION_LEVEL_GLOBAL,
        INVALID_PERMISSION_LEVEL_PER_METHOD_PROPERTY,
        INVALID_METHOD_NAME,
        UNSUPPORTED_METHOD,
        INVALID_PERMISSION_STRING,
        INVALID_PERMISSION_VALUE,
        INVALID_PERMISSION_VALUE_TYPE,
			
        // WebUsers:
        NO_OR_INVALID_PASSWORD,
        NO_PLATFORM_USER_ID,
        INVALID_PLATFORM_USER_ID,
        INVALID_CROSSPLATFORM_USER_ID,
        NO_USERNAME,
    }
}