using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace CommandExtensions.Commands {
	[UsedImplicitly]
	public class ConsoleCmdException : ConsoleCmdAbstract {
		public override string[] getCommands () {
			return new[] { "exception" };
		}

		public override bool AllowedInMainMenu => true;

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			Log.Out ("Test info");
			Log.Warning ("Test warning");
			Log.Error ("Test error");
			throw new Exception ("Test exception");
		}

		public override string getDescription () {
			return "Throw an exception / log messages";
		}
	}
}