using System.Collections.Generic;
using JetBrains.Annotations;

namespace MapRendering.Commands {
	[UsedImplicitly]
	public class EnableRendering : ConsoleCmdAbstract {
		public override string getDescription () {
			return "Disable live map rendering";
		}

		public override string getHelp () {
			return @"
			|Usage:
			|  1. enablerendering
			|  2. enablerendering <0/1>
			|1. Show current state of renderer
			|2. Disable/enable renderer
			|NOTE: This command can only turn the renderer off, it can not turn it on if it is not enabled in the serverconfig!
			".Unindent ();
		}

		public override string[] getCommands () {
			return new[] {"enablerendering"};
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			if (_params.Count != 1) {
				SdtdConsole.Instance.Output (
					$"Current state: {MapRenderer.Enabled && MapRenderer.renderingEnabled}{(!MapRenderer.Enabled ? " (disabled by serverconfig!)" : "")}");
				return;
			}

			MapRenderer.renderingEnabled = _params [0].Equals ("1");
			SdtdConsole.Instance.Output ($"Set live map rendering to {_params [0].Equals ("1")}");
		}
	}
}