using System.Reflection;
using HarmonyLib;
using JetBrains.Annotations;
using Webserver.UrlHandlers;

namespace Webserver {
	[UsedImplicitly]
	public class ModApi : IModApi {
		private Web webInstance;
		private Mod modInstance;
		
		public void InitMod (Mod _modInstance) {
			ModEvents.GameStartDone.RegisterHandler (GameStartDone);
			ModEvents.WorldShuttingDown.RegisterHandler (WorldShuttingDown);
			modInstance = _modInstance;

			Harmony.CreateAndPatchAll (Assembly.GetExecutingAssembly ());
		}

		private void GameStartDone () {
			if (!ConnectionManager.Instance.IsServer) {
				return;
			}
			
			webInstance = new Web (modInstance.Path);
			LogBuffer.Init ();

			if (ItemIconHandler.Instance != null) {
				ItemIconHandler.Instance.LoadIcons ();
			}
		}

		private void WorldShuttingDown () {
			webInstance?.Disconnect ();
		}
	}
}