using System.Reflection;
using HarmonyLib;
using JetBrains.Annotations;
using Webserver.UrlHandlers;

namespace Webserver {
	[UsedImplicitly]
	public class ModApi : IModApi {
		private Web webInstance;
		private Mod modInstance;
		
		public void InitMod (Mod _modInstance) {
			ModEvents.GameStartDone.RegisterHandler (GameStartDone);
			ModEvents.WorldShuttingDown.RegisterHandler (WorldShuttingDown);
			modInstance = _modInstance;

			Harmony.CreateAndPatchAll (Assembly.GetExecutingAssembly ());
		}

		private ModEvents.EModEventResult GameStartDone (ref ModEvents.SGameStartDoneData _data) {
			if (!ConnectionManager.Instance.IsServer) {
				return ModEvents.EModEventResult.Continue;
			}
			
			webInstance = new Web (modInstance.Path);
			LogBuffer.Init ();

			if (ItemIconHandler.Instance != null) {
				ItemIconHandler.Instance.LoadIcons ();
			}

			return ModEvents.EModEventResult.Continue;
		}

		private ModEvents.EModEventResult WorldShuttingDown (ref ModEvents.SWorldShuttingDownData _data) {
			webInstance?.Disconnect ();

			return ModEvents.EModEventResult.Continue;
		}
	}
}