using JetBrains.Annotations;
using Webserver;
using Webserver.UrlHandlers;

namespace MapRendering {
	[UsedImplicitly]
	public class ModApi : IModApi {
		private const string mapTilesBaseUrl = "/map/";
		
		public void InitMod (Mod _modInstance) {
			ModEvents.GameStartDone.RegisterHandler (GameStartDone);

			Web.ServerInitialized += _web => {
				if (!MapRenderer.Enabled) {
					return;
				}

				_web.RegisterPathHandler (mapTilesBaseUrl, new StaticHandler (
					$"{GameIO.GetSaveGameDir ()}/map",
					MapRenderer.GetTileCache (),
					false,
					"web.map")
				);

				_web.OpenApiHelpers.RegisterCustomSpec (GetType ().Assembly, "MapTileHandler", mapTilesBaseUrl);
			};
		}

		private void GameStartDone (ref ModEvents.SGameStartDoneData _data) {
			if (!MapRenderer.Enabled) {
				return;
			}

			ModEvents.GameShutdown.RegisterHandler (GameShutdown);
			ModEvents.CalcChunkColorsDone.RegisterHandler (CalcChunkColorsDone);
		}

		private void GameShutdown (ref ModEvents.SGameShutdownData _data) {
			MapRenderer.Shutdown ();
		}

		private void CalcChunkColorsDone (ref ModEvents.SCalcChunkColorsDoneData _data) {
			MapRenderer.RenderSingleChunk (_data.Chunk);
		}
	}
}
