using System.Collections.Generic;
using AllocsFixes.PersistentData;
using JetBrains.Annotations;
using Platform.Steam;

namespace AllocsFixes {
	[UsedImplicitly]
	public class API : IModApi {
		public void InitMod (Mod _modInstance) {
			ModEvents.GameStartDone.RegisterHandler (GameAwake);
			ModEvents.SavePlayerData.RegisterHandler (SavePlayerData);
			ModEvents.PlayerSpawning.RegisterHandler (PlayerSpawning);
			ModEvents.PlayerDisconnected.RegisterHandler (PlayerDisconnected);
			ModEvents.PlayerSpawnedInWorld.RegisterHandler (PlayerSpawned);
			ModEvents.ChatMessage.RegisterHandler (ChatMessage);
		}

		private static void GameAwake (ref ModEvents.SGameStartDoneData _data) {
			PersistentContainer.Load ();
		}

		private static void SavePlayerData (ref ModEvents.SSavePlayerDataData _data) {
			PersistentContainer.Instance.Players.GetOrCreate (_data.ClientInfo.InternalId, _data.ClientInfo.PlatformId, _data.ClientInfo.CrossplatformId).Update (_data.ClientInfo, _data.PlayerDataFile);
		}

		private static void PlayerSpawning (ref ModEvents.SPlayerSpawningData _data) {
			string owner = null;
			if (_data.ClientInfo.PlatformId is UserIdentifierSteam identifierSteam) {
				owner = identifierSteam.OwnerId.ToString ();
			}

			Log.Out (
				$"Player connected, entityid={_data.ClientInfo.entityId}, name={_data.ClientInfo.playerName}, pltfmid={_data.ClientInfo.PlatformId?.CombinedString ?? "<unknown>"}, crossid={_data.ClientInfo.CrossplatformId?.CombinedString ?? "<unknown/none>"}, steamOwner={owner ?? "<unknown/none>"}, ip={_data.ClientInfo.ip}"
			);
		}

		private static void PlayerDisconnected (ref ModEvents.SPlayerDisconnectedData _data) {
			Player p = PersistentContainer.Instance.Players.GetByInternalId (_data.ClientInfo.InternalId);
			if (p != null) {
				p.SetOffline ();
			} else {
				Log.Out ("Disconnected player not found in client list...");
			}

			PersistentContainer.Instance.Save ();
		}

		private static void PlayerSpawned (ref ModEvents.SPlayerSpawnedInWorldData _data) {
			if (_data.ClientInfo == null) {
				return;
			}
			
			PersistentContainer.Instance.Players.GetOrCreate (_data.ClientInfo.InternalId, _data.ClientInfo.PlatformId, _data.ClientInfo.CrossplatformId).SetOnline (_data.ClientInfo);
			PersistentContainer.Instance.Save ();
		}

		private const string ANSWER = "     [ff0000]I[-] [ff7f00]W[-][ffff00]A[-][80ff00]S[-] [00ffff]H[-][0080ff]E[-][0000ff]R[-][8b00ff]E[-]";

		private static ModEvents.EModEventResult ChatMessage (ref ModEvents.SChatMessageData _data) {
			if (string.IsNullOrEmpty (_data.Message) || !_data.Message.EqualsCaseInsensitive ("/alloc")) {
				return ModEvents.EModEventResult.Continue;
			}

			if (_data.ClientInfo != null) {
				Log.Out ($"Sent chat hook reply to {_data.ClientInfo.InternalId}");
				_data.ClientInfo.SendPackage (NetPackageManager.GetPackage<NetPackageChat> ().Setup (EChatType.Whisper, -1, ANSWER,  null, EMessageSender.Server, GeneratedTextManager.BbCodeSupportMode.Supported));
			} else {
				Log.Error ($"ChatHookExample: Argument _cInfo null on message: {_data.Message}");
			}

			return ModEvents.EModEventResult.StopHandlersAndVanilla;
		}
	}
}