﻿using System.Reflection;
using HarmonyLib;
using JetBrains.Annotations;

namespace FiniteItemRepairs
{
    [UsedImplicitly]
    public class ModMain : IModApi
    {
        public static Mod Mod;

        public void InitMod(Mod modInstance)
        {
            Mod = modInstance;
            Settings.Init();
            
            ModEvents.GameShutdown.RegisterHandler(OnGameShutdown);
            
            Harmony harmony = new(GetType().ToString());
            harmony.PatchAll(Assembly.GetExecutingAssembly());
        }

        private static void OnGameShutdown(ref ModEvents.SGameShutdownData data)
        {
            Settings.Save();
            Settings.DestroyFileWatcher();
        }
    }
}