using System.Collections.Generic;
using JetBrains.Annotations;

namespace FiniteItemRepairs {
	[UsedImplicitly]
	public class ConsoleCmdDegradationPercent : ConsoleCmdAbstract {
		public override string[] getCommands () {
			return new[] { "degradationpercent", "degperc" };
		}

		public override bool IsExecuteOnClient => true;
		public override bool AllowedInMainMenu => true;

		public override void Execute (List<string> parms, CommandSenderInfo senderInfo) {
			if (parms.Count == 0)
			{
				SdtdConsole.Instance.Output($"Current DegradationPercentage: {Settings.Data.DegradationPercent:P0} (== {Settings.Data.DegradationPercent})");
				return;
			}

			if (!StringParsers.TryParseFloat(parms[0], out float value))
			{
				SdtdConsole.Instance.Output("Can not parse input value as float");
				return;
			}

			Settings.Data.DegradationPercent = value;
		}

		public override string getDescription () {
			return "Get / set the degradation percentage per item repair";
		}
	}
}