using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;

public class AllocsNetTelnetServer
{
	private static ឦ console;
	private static Thread telnetThread;
	private static Dictionary<EndPoint, bool> endpointsAuthed;
	private static TcpListener listener;
	private static NetworkStream stream;
	private static bool closed;
	private static string lineRead = string.Empty;

	public static void init (int port)
	{
		listener = new TcpListener (IPAddress.Any, port);
		telnetThread = ThreadMaster.Create ("thread Allocs TelnetListenThread", new ThreadStart (telnetListenThread));
		telnetThread.Start ();
		endpointsAuthed = new Dictionary<EndPoint, bool> ();
		Console.Out.WriteLine ("Started Allocs NetTelnetServer thread on " + port);
//		Log.Out ("Started Allocs NetTelnetServer thread on " + port);
	}

	private static void telnetListenThread ()
	{
		Console.Out.WriteLine ("Started thread_Allocs_TelnetListenThread()");
		//Log.Out ("Started thread_Allocs_TelnetListenThread()");
		listener.Start ();
		while (!closed) {
			Thread.Sleep (10);
			TcpClient tcpClient = listener.AcceptTcpClient ();
			if (tcpClient != null) {
				try {
					Console.Out.WriteLine ("Someone connected to telnet!");
					endpointsAuthed.Add (tcpClient.Client.RemoteEndPoint, false);
					stream = tcpClient.GetStream ();
					StreamReader streamReader = new StreamReader (stream);
					WriteToClient ("Please enter password:");
					while (!closed && !endpointsAuthed[tcpClient.Client.RemoteEndPoint]) {
						lineRead = streamReader.ReadLine ();
						string text = string.Empty;
						lineCorrecter (ref text);
						text = text.Trim ();
						if (text.Equals (GamePrefs.GetString (EnumGamePrefs.TelnetPassword))) {
							endpointsAuthed [tcpClient.Client.RemoteEndPoint] = true;
							WriteToClient ("Logon successful.");
							WriteToClient (string.Empty);
							WriteToClient (string.Empty);
							WriteToClient (string.Empty);
						} else {
							WriteToClient ("Password incorrect, please enter password:");
						}
					}
					WriteToClient ("*** Connected with 7DTD server.");
					WriteToClient ("*** Server version: Alpha 8.7 (b29) Compatibility Version: Alpha 8.7");
					WriteToClient (string.Empty);
					WriteToClient ("Server IP:   " + 
						((GamePrefs.GetString (EnumGamePrefs.ServerIP) != null && GamePrefs.GetString (EnumGamePrefs.ServerIP).Length != 0) ? GamePrefs.GetString (EnumGamePrefs.ServerIP) : "Any")
					);
					WriteToClient ("Server port: " + GamePrefs.GetInt (EnumGamePrefs.ServerPort));
					WriteToClient ("Max players: " + GamePrefs.GetInt (EnumGamePrefs.ServerMaxPlayerCount));
					WriteToClient ("Game mode:   " + GamePrefs.GetString (EnumGamePrefs.GameMode));
					WriteToClient ("World:       " + GamePrefs.GetString (EnumGamePrefs.GameWorld));
					WriteToClient ("Game name:   " + GamePrefs.GetString (EnumGamePrefs.GameName));
					WriteToClient ("Difficulty:  " + GamePrefs.GetInt (EnumGamePrefs.GameDifficulty));
					WriteToClient (string.Empty);
					WriteToClient ("Press 'help' to get a list of all commands. Press 'exit' to end session.");
					WriteToClient (string.Empty);
					while (!closed) {
						lineRead = streamReader.ReadLine ();
						string text2 = string.Empty;
						lineCorrecter (ref text2);
						text2 = text2.Trim ();
						if (text2.Equals ("exit")) {
							endpointsAuthed [tcpClient.Client.RemoteEndPoint] = false;
							break;
						}

						if (text2.Length != 0) {
							Console.WriteLine ("Telnet executed \"" + text2 + "\" by " + tcpClient.Client.RemoteEndPoint);
//							console.᝚ᙂ (text2);
							lineRead = string.Empty;
						}
						Thread.Sleep (50);
					}
					if (stream != null) {
						endpointsAuthed [tcpClient.Client.RemoteEndPoint] = false;
						stream.Close ();
						stream = null;
					}
				} catch (Exception ex) {
					Console.Out.WriteLine ("Error in Allocs telnetListenThread: " + ex.Message);
					//Log.Out ("Error in Allocs telnetListenThread: " + ex.Message);
					Console.Out.WriteLine ("Stack Trace: " + ex.StackTrace);
					//Log.Out ("Stack Trace: " + ex.StackTrace);
				}
				if (stream != null) {
					endpointsAuthed [tcpClient.Client.RemoteEndPoint] = false;
					stream.Close ();
					stream = null;
				}
			}
		}
		Console.Out.WriteLine ("Exited thread_Allocs_TelnetListenThread()");
		//Log.Out ("Exited thread_Allocs_TelnetListenThread()");
		ThreadMaster.Remove (Thread.CurrentThread.Name);
	}

	private static void lineCorrecter (ref string line)
	{
		if (lineRead == null) {
			return;
		}
		for (int i = 0; i < lineRead.Length; i++) {
			if ((lineRead [i] == '\b' || lineRead [i] == '~') && line.Length > 0) {
				line = line.Substring (0, line.Length);
			}
			if (lineRead [i] >= ' ' && lineRead [i] != '\'' && lineRead [i] <= '~') {
				line += lineRead [i];
			}
		}
	}

	public static void Disconnect ()
	{
		closed = true;
		if (listener != null) {
			listener.Stop ();
		}
		if (stream != null) {
			stream.Close ();
		}
		Thread.Sleep (100);
	}

	public static void SetConsole (ឦ console)
	{
		AllocsNetTelnetServer.console = console;
	}

	public static void WriteToClient (string line)
	{
		if (line == null) {
			return;
		}
		if (stream != null) {
			for (int i = 0; i < line.Length; i++) {
				stream.WriteByte ((byte)line [i]);
			}
			stream.WriteByte (13);
			stream.WriteByte (10);
		}
	}
}
