using System;
using System.Reflection;
using Mono.Cecil;
using Mono.Cecil.Cil;

namespace dtdfixer
{
	class MainClass
	{
		public static void Main (string[] args)
		{
			ModuleDefinition module = ModuleDefinition.ReadModule ("Assembly-CSharp.dll");
			telnetPatch (module);
			connectLogPatch(module);
			module.Write ("Assembly-CSharp.dll");
			Console.WriteLine ("Done");
		}

		private static void connectLogPatch (ModuleDefinition module)
		{
			TypeDefinition type = module.GetType ("GameManager");

			if (isPatched (type)) {
				return;
			}

			markTypePatched (module, type);
			addHook (type, "RequestToSpawnPlayer", true, 5, typeof(AllocsRequestToSpawnPlayer).GetMethod ("RequestToSpawnPlayer"));
		}

		private static void telnetPatch (ModuleDefinition module)
		{
			TypeDefinition type = module.GetType ("NetTelnetServer");

			if (isPatched (type)) {
				return;
			}

			markTypePatched (module, type);
			replaceMethod (type, ".ctor", 1, typeof(AllocsNetTelnetServer).GetMethod ("init"));
			replaceMethod (type, "Disconnect", 0, typeof(AllocsNetTelnetServer).GetMethod ("Disconnect"));
			replaceMethod (type, "SetConsole", 1, typeof(AllocsNetTelnetServer).GetMethod ("SetConsole"));
			replaceMethod (type, "WriteToClient", 1, typeof(AllocsNetTelnetServer).GetMethod ("WriteToClient"));
		}

		private static void markTypePatched (ModuleDefinition module, TypeDefinition type)
		{
			type.Fields.Add (new FieldDefinition ("AllocsPatch", Mono.Cecil.FieldAttributes.Private | Mono.Cecil.FieldAttributes.SpecialName, module.Import (typeof(int))));
		}

		private static void addHook (TypeDefinition type, string methodName, bool addThisRef, int opCount, MethodBase targetMethod)
		{
			foreach (MethodDefinition method in type.Methods) {
				if (method.Name.Equals (methodName)) {
					Console.WriteLine ("Patching " + methodName);
					var il = method.Body.GetILProcessor ();
					var call = il.Create (OpCodes.Call, method.Module.Import (targetMethod));
					var i = 0;
					if (addThisRef)
						il.InsertBefore (method.Body.Instructions [i++], il.Create (OpCodes.Ldarg, 0));
					for (int op = 0; op < opCount; op++) {
						il.InsertBefore (method.Body.Instructions [i++], il.Create (OpCodes.Ldarg, op + 1));
					}
					il.InsertBefore (method.Body.Instructions [i++], call);
				}
			}
		}

		private static void replaceMethod (TypeDefinition type, string methodName, int opCount, MethodBase targetMethod)
		{
			foreach (MethodDefinition method in type.Methods) {
				if (method.Name.Equals (methodName)) {
					Console.WriteLine ("Patching " + methodName);
					var il = method.Body.GetILProcessor ();
					var call = il.Create (OpCodes.Call, method.Module.Import (targetMethod));
					var i = 0;
					for (int op = 0; op < opCount; op++) {
						il.InsertBefore (method.Body.Instructions [i++], il.Create (OpCodes.Ldarg, op + 1));
					}
					il.InsertBefore (method.Body.Instructions [i++], call);
					il.InsertBefore (method.Body.Instructions [i++], il.Create (OpCodes.Ret));
				}
			}
		}

		private static bool isPatched (TypeDefinition type)
		{
			foreach (FieldDefinition fd in type.Fields) {
				if (fd.Name.Equals ("AllocsPatch")) {
					Console.WriteLine ("\"" + type.Name + "\" is already patched, skipping");
					return true;
				}
			}
			Console.WriteLine ("Patching \"" + type.Name + "\"");
			return false;
		}
	}
}
