using System;
using System.Collections.Generic;

public class ListPlayersExtended : ConsoleCommand
{
	public ListPlayersExtended(ConsoleSdtd cons) : base(cons) {
	}

	public override string Description ()
	{
		return "lists all players with extended attributes";
	}

	public override string[] Names () {
		return new string[] { "listplayersextended", "lpe" };
	}

	public override void Run (string[] _params)
	{
		World w = this.m_Console.gameManager.World;
		int num = 0;
		foreach (KeyValuePair<int, EntityPlayer> current in w.playerEntities.dict)
		{
			int clientId = -1;
			Dictionary<int,int> d = this.m_Console.gameManager.connectionManager.mapClientToEntity;
			foreach (KeyValuePair<int, int> mapping in d) {
				if (mapping.Value == current.Value.fd0087) {
					clientId = mapping.Key;
				}
			}
			string ip = string.Empty;
			if (clientId >= 0) {
				ip = this.m_Console.gameManager.connectionManager.connectedClients [clientId].networkPlayer.ipAddress;
			}
			m_Console.md000a (string.Concat (new object[]
			{
				string.Empty,
				++num,
				". id=",
				current.Value.fd0087,
				", ",
				current.Value.EntityName,
				", pos=",
				current.Value.GetPosition (),
				", rot=",
				current.Value.rotation,
				", remote=",
				current.Value.fd00aa,
				", health=",
				current.Value.Health,
				", deaths=",
				current.Value.Died,
				", zombies=",
				current.Value.KilledZombies,
				", players=",
				current.Value.KilledPlayers,
				", score=",
				current.Value.Score,
				", steamid=",
				SingletonMonoBehaviour<Authenticator>.Instance.GetPlayerId (current.Value.EntityName),
				", ip=",
				ip
			}));
		}
		m_Console.md000a ("Total of " + w.playerEntities.list.Count + " in the game");
	}
}

