using System;
using System.Collections.Generic;

public class SayToPlayer : ConsoleCommand
{
	private GameManager manager;

	public SayToPlayer (ConsoleSdtd cons) : base(cons)
	{
		manager = m_Console.gameManager;
	}

	public override string Description ()
	{
		return "send a message to a single player";
	}

	public override string[] Names ()
	{
		return new string[] { "sayplayer", string.Empty };
	}

	public override void Run (string[] _params)
	{
		if (_params.Length < 2) {
			m_Console.md000a ("Usage: sayplayer <playername|entityid> <message>");
			return;
		}

		string message = _params [1];
		for (int i = 2; i < _params.Length; i++) {
			message += " " + _params [i];
		}

		int entityId = -1;
		if (int.TryParse (_params [0], out entityId)) {
			foreach (KeyValuePair<int, int> kvp in manager.connectionManager.mapClientToEntity) {
				if (kvp.Value == entityId) {
					int clientid = kvp.Key;
					ClientInfo ci = manager.connectionManager.connectedClients[clientid];
					if (ci != null) {
						manager.connectionManager.networkView.RPC ("RPC_ChatMessage", ci.networkPlayer, new object[] {
							message,
							-1,
							"Server (private)",
							true
							}
						);
						m_Console.md000a ("Message sent");
						return;
					}
				}
			}
			m_Console.md000a ("Entity ID not found.");
		} else {
			string destPlayerName = _params [0].ToLower ();
			foreach (ClientInfo ci in manager.connectionManager.connectedClients.Values) {
				Dictionary<int,int> d = manager.connectionManager.mapClientToEntity;
				if (d.ContainsKey (ci.clientId)) {
					entityId = d [ci.clientId];
					string curName = manager.World.playerEntities.dict [entityId].EntityName;
					if (curName.ToLower ().Equals (destPlayerName)) {
						manager.connectionManager.networkView.RPC ("RPC_ChatMessage", ci.networkPlayer, new object[] {
							message,
							-1,
							"Server (private)",
							true
							}
						);
						m_Console.md000a ("Message sent");
						return;
					}
				}
			}
			m_Console.md000a ("Playername not found.");
		}
	}
}

