using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Reflection;
using System.Threading;

public class AllocsNetTelnetServer
{
	private static ConsoleSdtd console = null;
	private static Thread telnetThread = null;
	private static TcpListener listener = null;
	private static bool closed = false;
	private static bool authEnabled = false;
	private static List<AllocsTelnetConnection> conns = new List<AllocsTelnetConnection> ();

	public static void init (int port)
	{
		Log.Out ("[7dtd-server-fixes by Alloc] Version: " + Assembly.GetExecutingAssembly ().GetName ().Version);
		authEnabled = GamePrefs.GetString (EnumGamePrefs.TelnetPassword).Length != 0;
		if (authEnabled)
			listener = new TcpListener (IPAddress.Any, port);
		else
			listener = new TcpListener (IPAddress.Loopback, port);
		telnetThread = ThreadMaster.Create ("thread Allocs TelnetListenThread", new ThreadStart (telnetListenThread));
		telnetThread.Start ();
		Log.Out ("Started Allocs NetTelnetServer thread on " + port);
	}

	private static void telnetListenThread ()
	{
		try {
			Log.Out ("Started thread_Allocs_TelnetListenThread()");
			listener.Start ();
			while (!closed) {
				Thread.Sleep (10);
				if (listener.Pending ()) {
					AllocsTelnetConnection c = new AllocsTelnetConnection (listener.AcceptTcpClient (), authEnabled);
					conns.Add (c);
					Log.Out ("Telnet connection from: " + c.GetEndPoint ());
					if (authEnabled) {
						c.WriteLine ("Please enter password:");
					} else {
						LoginMessage (c);
					}
				}

				foreach (AllocsTelnetConnection c in conns) {
					if (c.IsClosed ()) {
						c.Close ();
						conns.Remove (c);
						break;
					}
					if (c.Read ()) {
						string line = lineCorrecter (c.GetLine ());
						if (!c.IsAuthenticated ()) {
							if (line.Equals (GamePrefs.GetString (EnumGamePrefs.TelnetPassword))) {
								c.SetAuthenticated ();
								c.WriteLine ("Logon successful.");
								c.WriteLine (string.Empty);
								c.WriteLine (string.Empty);
								c.WriteLine (string.Empty);
								LoginMessage (c);
							} else {
								c.WriteLine ("Password incorrect, please enter password:");
							}
						} else {
							if (line.ToLower ().Equals ("exit")) {
								Log.Out ("Telnet connection closed by client: " + c.GetEndPoint ());
								c.Close ();
								conns.Remove (c);
								break;
							}
							Log.Out ("Telnet executed \"" + line + "\" from: " + c.GetEndPoint ());
							console.md000f (line);
						}
					}
				}
			}
			Log.Out ("Exited thread_Allocs_TelnetListenThread()");
			ThreadMaster.Remove (Thread.CurrentThread.Name);
		} catch (Exception ex) {
			Log.Out ("Error in Allocs telnetListenThread: " + ex.Message);
			Log.Out ("Stack Trace: " + ex.StackTrace);
		}
	}

	private static void LoginMessage (AllocsTelnetConnection c)
	{
		c.WriteLine ("*** Connected with 7DTD server.");
		c.WriteLine ("*** Server version: Alpha 8.7 (b29) Compatibility Version: Alpha 8.7");
		c.WriteLine (string.Empty);
		c.WriteLine ("Server IP:   " + 
			((GamePrefs.GetString (EnumGamePrefs.ServerIP) != null && GamePrefs.GetString (EnumGamePrefs.ServerIP).Length != 0) ? GamePrefs.GetString (EnumGamePrefs.ServerIP) : "Any")
		);
		c.WriteLine ("Server port: " + GamePrefs.GetInt (EnumGamePrefs.ServerPort));
		c.WriteLine ("Max players: " + GamePrefs.GetInt (EnumGamePrefs.ServerMaxPlayerCount));
		c.WriteLine ("Game mode:   " + GamePrefs.GetString (EnumGamePrefs.GameMode));
		c.WriteLine ("World:       " + GamePrefs.GetString (EnumGamePrefs.GameWorld));
		c.WriteLine ("Game name:   " + GamePrefs.GetString (EnumGamePrefs.GameName));
		c.WriteLine ("Difficulty:  " + GamePrefs.GetInt (EnumGamePrefs.GameDifficulty));
		c.WriteLine (string.Empty);
		c.WriteLine ("Press 'help' to get a list of all commands. Press 'exit' to end session.");
		c.WriteLine (string.Empty);
	}

	private static string lineCorrecter (string line)
	{
		string res = "";
		for (int i = 0; i < line.Length; i++) {
			if (line [i] >= ' ' && line [i] != '\'' && line [i] <= '~') {
				res += line [i];
			}
		}
		return res.Trim ();
	}

	public static void Disconnect ()
	{
		closed = true;
		if (listener != null) {
			listener.Stop ();
		}
		foreach (AllocsTelnetConnection c in conns) {
			c.Close ();
		}
		Thread.Sleep (100);
	}

	public static void SetConsole (ConsoleSdtd console)
	{
		Log.Out("Telnet SetConsole called");
		AllocsNetTelnetServer.console = console;
		console.AddCommand(new GetGamePrefs(console));
		console.AddCommand(new GetTime(console));
		console.AddCommand(new ListPlayersExtended(console));
		console.AddCommand(new SayToPlayer(console));
		console.AddCommand(new SetTimeReal(console));
	}

	private static void RemoveClosedConnections ()
	{
		foreach (AllocsTelnetConnection c in conns) {
			if (c.IsClosed ()) {
				c.Close ();
			}
		}
	}

	public static void WriteToClient (string line)
	{
		if (line == null) {
			return;
		}
		RemoveClosedConnections ();
		foreach (AllocsTelnetConnection c in conns) {
			if (c.IsAuthenticated ())
				c.WriteLine (line);
		}
	}
}
