using System;
using System.Collections.Generic;

public class AdminToolsStuff
{
	public static string[] GetAllowedCommandsList (AdminTools admTools, string _steamID)
	{
		AdminToolsClientInfo tmpInfo = admTools.GetClientCommandInfo (_steamID);

		List<AdminToolsCommandPermissions> perms = admTools.commandPermissions;
		List<string> allowed = new List<string> ();

		foreach (AdminToolsCommandPermissions atcp in perms) {
			if (tmpInfo.SteamID != null && tmpInfo.SteamID.Length > 0) {
				if ((atcp.PermissionLevel >= tmpInfo.PermissionLevel) || (atcp.PermissionLevel >= 1000)) {
					allowed.Add (atcp.Command);
				}
			} else {
				if (atcp.PermissionLevel >= 1000) {
					allowed.Add (atcp.Command);
				}
			}
		}

		return allowed.ToArray ();
	}
}

