using System;
using System.Collections.Generic;

public class AdminToolsStuff
{
	public static string[] GetAllowedCommandsList (AdminTools admTools, string _steamID)
	{
		AdminToolsClientInfo tmpInfo = admTools.GetClientCommandInfo (_steamID);

		List<AdminToolsCommandPermissions> perms = admTools.commandPermissions;
		List<string> allowed = new List<string> ();

		ConsoleSdtd console = ConnectionManager.Instance.gameManager.m_GUIConsole;

		foreach (AdminToolsCommandPermissions atcp in perms) {
			if (tmpInfo.SteamID != null && tmpInfo.SteamID.Length > 0) {
				if ((atcp.PermissionLevel >= tmpInfo.PermissionLevel) || (atcp.PermissionLevel >= 1000)) {
					addAllowed (console, allowed, atcp.Command);
				}
			} else {
				if (atcp.PermissionLevel >= 1000) {
					addAllowed (console, allowed, atcp.Command);
				}
			}
		}

		return allowed.ToArray ();
	}

	private static void addAllowed (ConsoleSdtd console, List<string> list, string cmd)
	{
		ConsoleCommand cc = console.getCommand (cmd);
		if (cc != null) {
			foreach (string ccName in cc.Names()) {
				if (!list.Contains (ccName)) {
					list.Add (ccName);
				}
			}
		} else {
			list.Add (cmd);
		}
	}
}

