#!/bin/sh

### BEGIN INIT INFO
# Provides:          7dtd-server
# Required-Start:    $remote_fs
# Required-Stop:     $remote_fs
# Should-Start:      $named
# Should-Stop:       $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: 7 Days to Die server
# Description:       Starts a 7 Days to Die server
### END INIT INFO

. /usr/local/bin/7dtd-common.sh
checkRootLoadConf

case "$1" in
    start)
    	echo "Starting all 7dtd instances:"
        for I in $SDTD_BASE/instances/*; do
            ins=`basename $I`
            echo "Starting: $ins"
            /usr/local/bin/7dtd-start.sh $ins
        done
        echo "All done"
    ;;
    stop)
    	echo "Stopping all 7dtd instances:"
        for I in $SDTD_BASE/instances/*; do
            ins=`basename $I`
            echo "Stopping: $ins"
            /usr/local/bin/7dtd-kill.sh $ins
            echo
            echo
        done
        echo "All done"
    ;;
    status)
        /usr/local/bin/7dtd-instances.sh
    ;;
    *)
        echo "Usage: ${0} {start|stop|status}"
        exit 2
esac
exit 0
