using System;
using System.Collections.Generic;

public class PlayerDataStuff
{
	public class PlayerItems
	{
		public SortedList<string, int> belt = new SortedList<string, int> ();
		public SortedList<string, int> bag = new SortedList<string, int> ();

		public PlayerItems (InventoryField[] belt, InventoryField[] bag)
		{
			foreach (InventoryField item in belt) {
				if (item.count > 0) {
					this.belt.Add (getInvFieldName (item), item.count);
				}
			}

			foreach (InventoryField item in bag) {
				if (item.count > 0) {
					this.bag.Add (getInvFieldName (item), item.count);
				}
			}
		}
	};

	private static Dictionary<int, PlayerItems> itemsPerEntityId = new Dictionary<int, PlayerItems> ();

	public static PlayerItems GetPlayerItems (int entityId)
	{
		if (itemsPerEntityId.ContainsKey (entityId))
			return itemsPerEntityId [entityId];
		else
			return null;
	}

	public static void GM_SavePlayerData (GameManager manager, int _clientId, PlayerDataFile _playerDataFile)
	{
		if (manager.connectionManager.mapClientToEntity.ContainsKey (_clientId)) {
			int entityId = manager.connectionManager.mapClientToEntity [_clientId];
			Log.Out ("Saving playerData for entity id: " + entityId);

			if (itemsPerEntityId.ContainsKey(entityId))
				itemsPerEntityId.Remove(entityId);
			itemsPerEntityId.Add (entityId, new PlayerItems (_playerDataFile.inventory, _playerDataFile.bag));
		}
		/*
		Log.Out ("Inventory of player:");
		for (int i = 0; i < _playerDataFile.inventory.Length; i++) {
			InventoryField item = _playerDataFile.inventory [i];
			printItem (item, i);
		}

		Log.Out ("Bag of player:");
		for (int i = 0; i < _playerDataFile.bag.Length; i++) {
			InventoryField item = _playerDataFile.bag [i];
			printItem (item, i);
		}*/
	}

	private static string getInvFieldName (InventoryField item)
	{
		ItemBase iBase = ItemBase.list [item.itemValue.type];
		string name = iBase.name;
		if (iBase.IsBlock ()) {
			ItemBlock iBlock = (ItemBlock)iBase;
			name = iBlock.GetItemName (item.itemValue);
		}
		return name;
	}

	private static void printItem (InventoryField item, int slot)
	{
		if (item.count > 0) {
			ItemBase iBase = ItemBase.list [item.itemValue.type];
			string name = iBase.name;
			if (iBase.IsBlock ()) {
				ItemBlock iBlock = (ItemBlock)iBase;
				name = iBlock.GetItemName (item.itemValue);
			}
			Log.Out (string.Format ("Slot {0:00}: {1:00} * {2}", slot, item.count, name));
		}
	}
}

