using System;
using System.Collections.Generic;

public class ShowInventory : ConsoleCommand
{
	private GameManager manager;

	public ShowInventory (ConsoleSdtd cons) : base(cons)
	{
		manager = m_Console.gameManager;
	}

	public override string Description ()
	{
		return "list inventory of a given player (entity id or name)";
	}

	public override string[] Names ()
	{
		return new string[] { "showinventory", "si" };
	}

	public override void Run (string[] _params)
	{
		if (_params.Length < 1) {
			m_Console.md000a ("Usage: showinventory <playername|entityid>");
			return;
		}

		int entityId = -1;
		PlayerDataStuff.PlayerItems items = null;
		if (int.TryParse (_params [0], out entityId)) {
			items = PlayerDataStuff.GetPlayerItems (entityId);
		}

		if (items == null) {
			string playerName = _params [0].ToLower ();
			foreach (KeyValuePair<int, EntityPlayer> kvp in manager.World.playerEntities.dict) {
				if (kvp.Value.EntityName.ToLower ().Equals (playerName)) {
					entityId = kvp.Key;
					break;
				}
			}
		}
		items = PlayerDataStuff.GetPlayerItems (entityId);

		if (items == null) {
			m_Console.md000a ("Playername or entity id not found or no inventory saved (first saved after a player has been online for 30s).");
			return;
		}

		m_Console.md000a ("Belt of player:");
		foreach (KeyValuePair<string, int> kvp in items.belt) {
			m_Console.md000a (string.Format ("    {0:000} * {1}", kvp.Value, kvp.Key));
		}
		m_Console.md000a (string.Empty);
		m_Console.md000a ("Bagpack of player:");
		foreach (KeyValuePair<string, int> kvp in items.bag) {
			m_Console.md000a (string.Format ("    {0:000} * {1}", kvp.Value, kvp.Key));
		}
		m_Console.md000a (string.Empty);
	}
}

