#!/bin/bash
# requires:
# imagemagick, bc

#map = 6x6 blocks
#one block: 512
#image size: 1536x1536

cd /home/sdtd/7draw/

TELNET_PWD=volume7
TELNET_PORT=8081
#. /etc/7dtd.conf

RADIUS=5
LP=`echo -e "$TELNET_PWD\nlp" | nc -q 2 localhost $TELNET_PORT`
POSLINES=`echo "$LP" | grep -oE "pos=\([^)]*\)"`
# remove brackets
POSLINES=`echo "$POSLINES" | tr -d ")("`

#enable for debug
#POSLINES="-221.7, 85.0, -684.6\n221.7, 85.0, 684.6"
if [ -n "$POSLINES" ]; then
   DATE=`date +"%Y.%m.%d"`
   HOUR=`date +"%H"`
   MIN=`date +"%M"`
   HUE=`echo "(100 * (($HOUR * 60) + $MIN)) / 1440" | bc`
   COLOR="hsb($HUE%, 100%, 100%)"
   IMG_OUT="map_$DATE.png"
   if [ ! -f "$IMG_OUT" ]; then
      IMG_IN=NavezganeMap.png
   else
      IMG_IN="$IMG_OUT"
   fi
   echo -e "$POSLINES" | while IFS=", " read x _ y
   do
      X=`echo "768 - $x/2" | bc`
      Y=`echo "768 - $y/2" | bc`
      X2=`echo "$X+$RADIUS" | bc`
      Y2=`echo "$Y+$RADIUS" | bc`
      `convert "$IMG_IN" -fill "$COLOR" -draw "circle $X,$Y $X2,$Y2" "$IMG_OUT"`
      IMG_IN="$IMG_OUT"
   done
fi
